/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

// I also parameterised the loop counts for flexibility and rearranged
// things for efficiency. Though it looks different it is still almost
// the same shader as the original I took from GlsSandbox.com, TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////
#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;
// uniform vec2 mouse;
// uniform vec2 resolution;

#define OCTAVES 20

float vn(vec2 pos, float persistence, float scale)
{
	float v = 0.0;
	float p = 1.0;
	for (int i=OCTAVES-1; i>=0; --i)
	{
		v += (sin(pos.x)+cos(pos.y))*p;
		pos += sin(pos.yx+vec2(time+cos(time), 0.6));
		p *= persistence;
		pos /= scale;
	}
	return v;
}

void main( void )
{

	vec2 uv = ( scaled_gl_FragCoord.xy / resolution.xy );

	float c = vn(uv*10.0, 0.5, 0.5);

	gl_FragColor = vec4( cos(c)*0.5+0.5 );
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15

}